<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMessagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('numero');
            $table->text('mensagem');
            $table->unsignedBigInteger('user_id')->constrained()->onUpdate('cascade')->onDelete('cascade')->nullable();
            $table->unsignedBigInteger('client_id')->constrained()->onUpdate('cascade')->onDelete('cascade')->nullable();
            $table->unsignedBigInteger('atendente_id')->constrained()->onUpdate('cascade')->onDelete('cascade')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('messages');
    }
}
